############### ###############
## F_H3_1
## Project: CBO
## Author: Kamil Kouhen
## Date of creation: 23/06/2022
############### ###############

#Uniform Path
path <- here("Output/For Publication/Figures/F_")

  pct_format = scales::percent_format(accuracy = .1)
  
  plot1 <- ggplot(DM_final,
                  aes(x = factor(A_bin_decideurs_important))) + 
    geom_bar() + 
    labs(
      x = "...most important actors to keep happy, \n in order to maintain influence", 
      y = "Number of decision makers"
    ) + 
    scale_x_discrete(labels = c('No','Yes', "Missing")) + 
    geom_text(aes(
      label = sprintf('%d \n (%s)',
                      ..count..,
                      pct_format(..count.. / sum(..count..)))),
      stat = 'count',
      nudge_y = .2,
      colour = 'black',
      size = 2.5, 
      vjust = -0.2) + 
    theme_minimal() +
    theme(text = element_text(size=11, family="Times")) + 
    scale_y_continuous(limits = c(0,700)) 
  
  plot2 <- ggplot(DM_final,
                  aes(x = factor(A_bin_decideurs_justify))) + 
    geom_bar() + 
    labs(
      x = "...actors to whom municipal decision makers \n spend the most effort justifying their decisions", 
      y = "Number of decision makers"
    ) + 
    scale_x_discrete(labels = c('No','Yes', "Missing")) + 
    geom_text(aes(
      label = sprintf('%d \n (%s)',
                      ..count..,
                      pct_format(..count.. / sum(..count..)))),
      stat = 'count',
      nudge_y = .2,
      colour = 'black',
      size = 2.5, 
      vjust = -0.5) + 
    theme_minimal() +
    theme(text = element_text(size=11, family="Times"), 
          axis.title.y=element_blank()) + 
    scale_y_continuous(limits = c(0,700))
  
  plot <- ggarrange(plot1, plot2,
                    widths = c(0.5, 0.5), 
                    align = "hv") +
    theme(plot.margin=grid::unit(c(0,0,0,0), "mm"))
  
  annotate_figure(plot, top = text_grob("Community groups and civil society are among the three...", 
                                        size = 11, family = "Times"))
  
  rm(plot, plot1, plot2)
  
  ggsave(width = 7, height = 4, filename = paste0(path, "H3_", "1.png"), device = png,  dpi=200)



